% estimate: Estimate illuminant color
%
% w = estimate(imgpc,saveloc)
%
%   imgpc:   Name of .mat file with precomputed data from precompute
%   saveloc: Name of .mat file with training data
%
% RESULT:
%   w:       3x1 Vector corresponding to illuminant color
% Note, this will save imgpc.w.mat with the computed A matrix, to be
% used by estimatePrior and estimatePriorWL
function ell = estimate(imgpc,saveloc)
  
  load('-mat',saveloc);
  fouts = loadpc(imgpc);

  numbands = length(fouts);
  A = zeros(3,3);
  ell = [1 1 1]';
  % Filter and aggregate sufficient statistics
  for iters = 1:6
    [A,NK] = getA(fouts,cov_t,ell);
    ello = ell; ell = atoell(A);
    if ferr(ello,ell) < 0.005
      break;
    end;
  end;

  save('-mat',[imgpc '.w.mat'],'A','NK','ell');
  
  
  ell = ell(:) / sqrt(sum(ell.^2));

% calculating angular error
function g = ferr(lo,l)
  lo = lo(:) / sqrt(sum(lo.^2));
  l = l(:) / sqrt(sum(l.^2));
  g = acosd(sum(l.*lo));
  
function [A,NK] = getA(fouts,si,m)
  
  A = zeros(3,3);
  NK = 0;
  for i = 1:length(fouts)
    d = fouts{i};
    
    NK = NK + size(d,1);
    dm = d * diag(1./m);
    wts = sum(dm .* (dm * si(:,:,i)),2); 
    wts = abs(wts).^(0.25);
    
    d = d ./ repmat(max(wts,10^-24),[1 3]);
    A = A + (d'*d) .* si(:,:,i);
  end;
  A = 4*A/NK;
  
function ell = atoell(A)
  
  ell = sqrt(diag(A));
  C = inf;
  for it = 1:40
    for i = 1:3
      sj = sum(A(:,i) ./ ell(:)) - A(i,i)/ell(i);
      ell(i) = 0.5*(sj + sqrt(sj^2 + 4*A(i,i)));
    end;
    Cn = sum(log(ell)) + 0.5*ell'*A*ell;
    if Cn > (1-10^-4)*C
      break;
    end;
    C = Cn;
  end;
